/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.gui;

import mcp.mobius.waila.Waila;
import mcp.mobius.waila.api.impl.config.WailaConfig;
import mcp.mobius.waila.gui.GuiOptions;
import mcp.mobius.waila.gui.config.OptionsEntryButton;
import mcp.mobius.waila.gui.config.OptionsListWidget;
import mcp.mobius.waila.gui.config.value.OptionsEntryValueBoolean;
import mcp.mobius.waila.gui.config.value.OptionsEntryValueCycle;
import mcp.mobius.waila.gui.config.value.OptionsEntryValueEnum;
import mcp.mobius.waila.gui.config.value.OptionsEntryValueInput;
import mcp.mobius.waila.gui.config.value.OptionsEntryValueSlider;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.lang3.StringEscapeUtils;

public class GuiConfigWaila
extends GuiOptions {
    public GuiConfigWaila(Screen parent) {
        super(parent, (ITextComponent)new TranslationTextComponent("gui.waila.configuration", new Object[]{"Waila"}), Waila.CONFIG::save, Waila.CONFIG::invalidate);
    }

    @Override
    public OptionsListWidget getOptions() {
        final WailaConfig.ConfigGeneral general = Waila.CONFIG.get().getGeneral();
        final WailaConfig.ConfigOverlay overlay = Waila.CONFIG.get().getOverlay();
        final WailaConfig.ConfigFormatting formatting = Waila.CONFIG.get().getFormatting();
        OptionsListWidget options = new OptionsListWidget(this, this.field_230706_i_, this.field_230708_k_ + 45, this.field_230709_l_, 32, this.field_230709_l_ - 32, 30, Waila.CONFIG::save);
        options.add(new OptionsEntryButton("general", new Button(0, 0, 100, 20, StringTextComponent.field_240750_d_, w -> this.field_230706_i_.func_147108_a((Screen)new GuiOptions(this, "general"){

            @Override
            public OptionsListWidget getOptions() {
                OptionsListWidget options = new OptionsListWidget(this, this.field_230706_i_, this.field_230708_k_ + 45, this.field_230709_l_, 32, this.field_230709_l_ - 32, 30);
                options.add(new OptionsEntryValueBoolean("display_tooltip", general.shouldDisplayTooltip(), general::setDisplayTooltip));
                options.add(new OptionsEntryValueEnum("display_fluids", (Enum[])RayTraceContext.FluidMode.values(), (Enum)general.getDisplayFluids(), general::setDisplayFluids));
                options.add(new OptionsEntryValueBoolean("sneaky_details", general.shouldShiftForDetails(), general::setShiftForDetails));
                options.add(new OptionsEntryValueEnum("display_mode", (Enum[])WailaConfig.DisplayMode.values(), (Enum)general.getDisplayMode(), general::setDisplayMode));
                options.add(new OptionsEntryValueBoolean("hide_from_debug", general.shouldHideFromDebug(), general::setHideFromDebug));
                options.add(new OptionsEntryValueEnum("display_item", (Enum[])WailaConfig.IconMode.values(), (Enum)general.getIconMode(), general::setIconMode));
                options.add(new OptionsEntryValueSlider("reach_distance", general.getReachDistance(), general::setReachDistance, 0.0f, 20.0f));
                options.add(new OptionsEntryValueBoolean("tts", general.shouldEnableTextToSpeech(), general::setEnableTextToSpeech));
                return options;
            }
        }))));
        options.add(new OptionsEntryButton("overlay", new Button(0, 0, 100, 20, StringTextComponent.field_240750_d_, w -> this.field_230706_i_.func_147108_a((Screen)new GuiOptions(this, "overlay"){

            @Override
            public OptionsListWidget getOptions() {
                OptionsListWidget options = new OptionsListWidget(this, this.field_230706_i_, this.field_230708_k_ + 45, this.field_230709_l_, 32, this.field_230709_l_ - 32, 30);
                options.add(new OptionsEntryValueSlider("overlay_alpha", overlay.getColor().getRawAlpha(), val -> overlay.getColor().setAlpha((int)val.floatValue()), 0.0f, 100.0f));
                options.add(new OptionsEntryValueCycle("overlay_theme", (String[])overlay.getColor().getThemes().stream().map(t -> t.getId().toString()).sorted(String::compareToIgnoreCase).toArray(String[]::new), overlay.getColor().getTheme().getId().toString(), val -> overlay.getColor().applyTheme(new ResourceLocation(val))));
                options.add(new OptionsEntryValueBoolean("overlay_square", overlay.getSquare(), overlay::setSquare));
                options.add(new OptionsEntryValueSlider("overlay_pos_x", overlay.getOverlayPosX(), overlay::setOverlayPosX));
                options.add(new OptionsEntryValueSlider("overlay_pos_y", overlay.getOverlayPosY(), overlay::setOverlayPosY));
                options.add(new OptionsEntryValueSlider("overlay_anchor_x", overlay.getAnchorX(), overlay::setAnchorX));
                options.add(new OptionsEntryValueSlider("overlay_anchor_y", overlay.getAnchorY(), overlay::setAnchorY));
                options.add(new OptionsEntryValueBoolean("flip_main_hand", overlay.getFlipMainHand(), overlay::setFlipMainHand));
                return options;
            }
        }))));
        options.add(new OptionsEntryButton("formatting", new Button(0, 0, 100, 20, StringTextComponent.field_240750_d_, w -> this.field_230706_i_.func_147108_a((Screen)new GuiOptions(this, "formatting"){

            @Override
            public OptionsListWidget getOptions() {
                OptionsListWidget options = new OptionsListWidget(this, this.field_230706_i_, this.field_230708_k_ + 45, this.field_230709_l_, 32, this.field_230709_l_ - 32, 30);
                options.add(new OptionsEntryValueInput<String>("format_mod_name", StringEscapeUtils.escapeJava((String)formatting.getModName()), val -> formatting.setModName(val.isEmpty() || !val.contains("%s") ? formatting.getModName() : val)));
                options.add(new OptionsEntryValueInput<String>("format_block_name", StringEscapeUtils.escapeJava((String)formatting.getBlockName()), val -> formatting.setBlockName(val.isEmpty() || !val.contains("%s") ? formatting.getBlockName() : val)));
                options.add(new OptionsEntryValueInput<String>("format_fluid_name", StringEscapeUtils.escapeJava((String)formatting.getFluidName()), val -> formatting.setFluidName(val.isEmpty() || !val.contains("%s") ? formatting.getFluidName() : val)));
                options.add(new OptionsEntryValueInput<String>("format_entity_name", StringEscapeUtils.escapeJava((String)formatting.getEntityName()), val -> formatting.setEntityName(val.isEmpty() || !val.contains("%s") ? formatting.getEntityName() : val)));
                options.add(new OptionsEntryValueInput<String>("format_registry_name", StringEscapeUtils.escapeJava((String)formatting.getRegistryName()), val -> formatting.setRegistryName(val.isEmpty() || !val.contains("%s") ? formatting.getRegistryName() : val)));
                return options;
            }
        }))));
        return options;
    }
}

